package com.jay.example.service;

import java.io.File;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.content.Context;
import android.util.Log;





import com.jay.example.db.FileService;

public class FileDownloadered {
	
	private static final String TAG = "ļ";  //һlogʱһ־
	private static final int RESPONSEOK = 200;    //ӦΪ200,ʳɹ
	private FileService fileService;			  //ȡݿҵBean
	private boolean exited;						  //ֹͣصı־
	private Context context;					  //Ķ
	private int downloadedSize = 0;               //صļ
	private int fileSize = 0;					  //ʼļ
	private DownloadThread[] threads;        //߳ص̳߳
	private File saveFile;						  //ݱ浽صļ
	private Map<Integer, Integer> data = new ConcurrentHashMap<Integer, Integer>();  //̵߳صĳ
	private int block;                            //ÿ߳صĳ
	private String downloadUrl;                   //ص·
	
	
	/**
	 * ȡ߳
	 */
	public int getThreadSize()
	{
		//return threads.length;
		return 0;
	}
	
	/**
	 * ˳
	 * */
	public void exit()
	{
		this.exited = true;    //˳ı־Ϊtrue;
	}
	public boolean getExited()
	{
		return this.exited;
	}
	
	/**
	 * ȡļĴС
	 * */
	public int getFileSize()
	{
		return fileSize;
	}
	
	/**
	 * ۼصĴС
	 * ʹͬķ
	 * */
	protected synchronized void append(int size)
	{
		//ʵʱصĳȼ뵽ܵس
		downloadedSize += size;
	}
	
	/**
	 * ָ߳صλ
	 * @param threadId ߳id
	 * @param pos صλ
	 * */
	protected synchronized void update(int threadId,int pos)
	{
		//ָ߳id̸߳µس,ǰֵᱻǵ
		this.data.put(threadId, pos);
		//ݿƶ̵߳س
		this.fileService.update(this.downloadUrl, threadId, pos);
	}
	
	
	/**
	 * ļ
	 * @param downloadUrl ·
	 * @param fileSaveDir ļıĿ¼
	 * @param threadNum  ߳
	 * @return 
	 */
	public FileDownloadered(Context context,String downloadUrl,File fileSaveDir,int threadNum)
	{
		try {
			this.context = context;     //ȡĶ,ֵ
			this.downloadUrl = downloadUrl;  //Ϊ·ֵ
			fileService = new FileService(this.context);   //ʵݿҵBean,Ҫһcontextֵ
			URL url = new URL(this.downloadUrl);     //·ʵURL
			if(!fileSaveDir.exists()) fileSaveDir.mkdir();  //ļڵĻָĿ¼,ɴĿ¼
			this.threads = new DownloadThread[threadNum];   //ص߳ص̳߳
			
			
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();   //ԶӾ,ﲢδ
			conn.setConnectTimeout(5000);      //ӳʱ¼Ϊ5
			conn.setRequestMethod("GET");      //ʽΪGET
			//û˿Խյý
			conn.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, " +
					"image/pjpeg, application/x-shockwave-flash, application/xaml+xml, " +
					"application/vnd.ms-xpsdocument, application/x-ms-xbap," +
					" application/x-ms-application, application/vnd.ms-excel," +
					" application/vnd.ms-powerpoint, application/msword, */*");
			
			conn.setRequestProperty("Accept-Language", "zh-CN");  //û
			conn.setRequestProperty("Referer", downloadUrl);    //Դҳ,ڷ˽Դͳ
			conn.setRequestProperty("Charset", "UTF-8");		//ÿͻ˱
			//û
			conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; " +
					"Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727;" +
					" .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
			
			conn.setRequestProperty("Connection", "Keep-Alive");  //connectionķʽ
			conn.connect();      //ԶԴڵ,޷ص
			printResponseHeader(conn);   //ӡصHttpͷֶμ
			//Էص״̬ж,ڼǷɹ,200ʱִĴ
			if(conn.getResponseCode() == RESPONSEOK)
			{
				this.fileSize = conn.getContentLength();  //ӦļС
				if(this.fileSize <= 0)throw new RuntimeException("֪ļС");  //ļСڵ0ʱ׳ʱ쳣
				String filename = getFileName(conn);      //ȡļ
				this.saveFile = new File(fileSaveDir,filename);  //ļĿ¼ļļ
				Map<Integer,Integer> logdata = fileService.getData(downloadUrl);    //ȡؼ¼
				//ؼ¼
				if(logdata.size() > 0)
				{
					//е,ÿ߳صݳȷdata
					for(Map.Entry<Integer, Integer> entry : logdata.entrySet())
					{
						data.put(entry.getKey(), entry.getValue());
					}
				}
				//صݵ߳õ߳ͬʱֳѾصܳ
				if(this.data.size() == this.threads.length)
				{
					//ÿ߳ص
					for(int i = 0;i < this.threads.length;i++)
					{
						this.downloadedSize += this.data.get(i+1);
					}
					print("صĳ" + this.downloadedSize + "ֽ");
				}
				//ʹÿ߳Ҫصݳ
				this.block = (this.fileSize % this.threads.length) == 0?
						this.fileSize / this.threads.length:
							this.fileSize / this.threads.length + 1;
			}else{
				//ӡϢ
				print("Ӧ:" + conn.getResponseCode() + conn.getResponseMessage());
				throw new RuntimeException("");
			}
			
			
		}catch (Exception e) 
		{
			print(e.toString());   //ӡ
			throw new RuntimeException("޷URL");
		}
	}

	
	/**
	 * ȡļ
	 * */
	private String getFileName(HttpURLConnection conn)
	{
		//ص·ַлȡļ
		String filename = this.downloadUrl.substring(this.downloadUrl.lastIndexOf('/') + 1);
		if(filename == null || "".equals(filename.trim())){     //ȡļ
		for(int i = 0;;i++)  //ʹѭ
		{
			String mine = conn.getHeaderField(i);     //ӷصлȡضͷֶεֵ
			if (mine == null) break;				  //˷ͷĩβ˳ѭ
			//ȡcontent-dispositionֶ,ܰļ
			if("content-disposition".equals(conn.getHeaderFieldKey(i).toLowerCase())){
				//ʹʽѯļ
				Matcher m = Pattern.compile(".*filename=(.*)").matcher(mine.toLowerCase());
				if(m.find()) return m.group(1);    //зʽַ,
			}
		}
		filename = UUID.randomUUID()+ ".tmp";//ûҵĻ,Ĭȡһļ
		//ʶ(ÿΨһıʶ)ԼCPUʱΨһɵһ16ֽڵĶΪļ
		}
			return filename;
	}
	
	/**
	 *  ʼļ
	 * @param listener ı仯,Ҫ˽ʵʱص,Ϊnull
	 * @return ļС
	 * @throws Exception
	 */
	//,쳣Ļ,׳쳣
	public int download(DownloadProgressListener listener) throws Exception{
		try {
			RandomAccessFile randOut = new RandomAccessFile(this.saveFile, "rwd");
			//ļС
			if(this.fileSize>0) randOut.setLength(this.fileSize);
			randOut.close();    //رոļ,ʹЧ
			URL url = new URL(this.downloadUrl);
			if(this.data.size() != this.threads.length){//ԭδػԭȵ߳ڵ߳һ
				this.data.clear();
				//̳߳
				for (int i = 0; i < this.threads.length; i++) {
					this.data.put(i+1, 0);//ʼÿ߳ѾصݳΪ0
				}
				this.downloadedSize = 0;   //ѾصĳΪ0
			}
			
			for (int i = 0; i < this.threads.length; i++) {//߳̽
				int downLength = this.data.get(i+1);   //ͨض߳idȡ߳Ѿصݳ
				//ж߳ǷѾ,	
				if(downLength < this.block && this.downloadedSize<this.fileSize){
					//ʼضid߳
					this.threads[i] = new DownloadThread(this, url, this.saveFile, this.block, this.data.get(i+1), i+1);
					//߳ȼ,Thread.NORM_PRIORITY = 5;Thread.MIN_PRIORITY = 1;Thread.MAX_PRIORITY = 10,ֵԽȼԽ
					this.threads[i].setPriority(7);   
					this.threads[i].start();    //߳
				}else{
					this.threads[i] = null;   //߳
				}
			}
			
			fileService.delete(this.downloadUrl);           //ؼ¼ɾǣȻ
			fileService.save(this.downloadUrl, this.data);  //صʵʱдݿ
			boolean notFinish = true;					    //δ
			while (notFinish) {								// ѭж߳Ƿ
				Thread.sleep(900);
				notFinish = false;						    //ٶȫ߳
				for (int i = 0; i < this.threads.length; i++){
					if (this.threads[i] != null && !this.threads[i].isFinish()) {//߳δ
						notFinish = true;										//ñ־Ϊû
						if(this.threads[i].getDownLength() == -1){				//ʧ,صݳȵĻ
							//¿߳,̵߳ȼ
							this.threads[i] = new DownloadThread(this, url, this.saveFile, this.block, this.data.get(i+1), i+1);
							this.threads[i].setPriority(7);
							this.threads[i].start();
						}
					}
				}				
				if(listener!=null) listener.onDownloadSize(this.downloadedSize);//֪ͨĿǰѾɵݳ
			}
			if(downloadedSize == this.fileSize) fileService.delete(this.downloadUrl);//ɾ¼
		} catch (Exception e) {
			print(e.toString());
			throw new Exception("ļ쳣");
		}
		return this.downloadedSize;
	}
	
	
	/**
	 * ȡHttpӦͷֶ
	 * @param http
	 * @return
	 */
	public static Map<String, String> getHttpResponseHeader(HttpURLConnection http) {
		//ʹLinkedHashMap֤дͱʱ˳ͬ,ֵ
		Map<String, String> header = new LinkedHashMap<String, String>();
		//˴ʹѭ,Ϊ֪ͷֶε
		for (int i = 0;; i++) {
			String mine = http.getHeaderField(i);  //ȡiͷֶεֵ
			if (mine == null) break;			//ûֵ˵ͷֶѾѭ,ʹbreakѭ
			header.put(http.getHeaderFieldKey(i), mine); //õiͷֶεļ
		}
		return header;
	}
	/**
	 * ӡHttpͷֶ
	 * @param http
	 */
	public static void printResponseHeader(HttpURLConnection http){
		//ȡhttpӦͷֶ
		Map<String, String> header = getHttpResponseHeader(http);
		//ʹǿforѭȡͷֶεֵ,ʱѭ˳ѫͬ
		for(Map.Entry<String, String> entry : header.entrySet()){
			//мʱȡֵ,ûΪַ
			String key = entry.getKey()!=null ? entry.getKey()+ ":" : "";
			print(key+ entry.getValue());      //ӡֵ
		}
	}
	
	
	
	
	/**
	 * ӡϢ
	 * @param msg Ϣַ
	 * */
	private static void print(String msg) {
		Log.i(TAG, msg);
	}

	
	
	
}
