package com.jay.example.multhreadcontinuabledemo;


import java.io.File;

import com.jay.example.service.FileDownloadered;


import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;


public class MainActivity extends Activity {

	private EditText editpath;
	private Button btndown;
	private Button btnstop;
	private TextView textresult;
	private ProgressBar progressbar;
	private static final int PROCESSING = 1;   //ʵʱݴMessage־
	private static final int FAILURE = -1;	   //ʧʱMessage־
	
	
	private Handler handler = new UIHander();
    
    private final class UIHander extends Handler{
		public void handleMessage(Message msg) {
			switch (msg.what) {
			//ʱ
			case PROCESSING:
				int size = msg.getData().getInt("size");     //ϢлȡѾصݳ
				progressbar.setProgress(size);				 //ýĽ
				//Ѿصİٷֱ,˴ҪתΪ
				float num = (float)progressbar.getProgress() / (float)progressbar.getMax();
				int result = (int)(num * 100);     //ѻȡĸתΪ
				textresult.setText(result+ "%");   //صİٷֱʾؼ
				if(progressbar.getProgress() == progressbar.getMax()){ //ʱʾ
					Toast.makeText(getApplicationContext(), "ļسɹ", 1).show();
				}
				break;

			case FAILURE:    //ʧʱʾ
				Toast.makeText(getApplicationContext(), "ļʧ", 1).show();
				break;
			}
		}
    }
	
	
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		editpath = (EditText) findViewById(R.id.editpath);
		btndown = (Button) findViewById(R.id.btndown);
		btnstop = (Button) findViewById(R.id.btnstop);
		textresult = (TextView) findViewById(R.id.textresult);
		progressbar = (ProgressBar) findViewById(R.id.progressBar);
		ButtonClickListener listener = new ButtonClickListener();
		btndown.setOnClickListener(listener);
		btnstop.setOnClickListener(listener);
		
		
	}
	
	
	private final class ButtonClickListener implements View.OnClickListener{
		public void onClick(View v) {
			switch (v.getId()) {
			case R.id.btndown:
				String path = editpath.getText().toString();
				if(Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)){
					File saveDir = Environment.getExternalStorageDirectory();
					download(path, saveDir);
				}else{
					Toast.makeText(getApplicationContext(), "sdȡʧ", 1).show();
				}
				btndown.setEnabled(false);
				btnstop.setEnabled(true);
				break;

			case R.id.btnstop:
				exit();
				btndown.setEnabled(true);
				btnstop.setEnabled(false);
				break;
			}
		}
		/*
		û¼(button, Ļ....)̸߳ģ̴߳ڹ״̬
		ʱû¼û5ڵõϵͳͻᱨӦӦ
		߳ﲻִһȽϺʱĹ߳޷û¼
		¡ӦӦĳ֡ʱĹӦִ߳С
		 */
		private DownloadTask task;
		/**
		 * ˳
		 */
		public void exit(){
			if(task!=null) task.exit();
		}
		private void download(String path, File saveDir) {//߳
			task = new DownloadTask(path, saveDir);
			new Thread(task).start();
		}
		
		
		/*
		 * UIؼػ()̸߳ģ߳иUIؼֵºֵػ浽Ļ
		 * һҪ߳UIؼֵĻʾ߳иUIؼֵ
		 */
		private final class DownloadTask implements Runnable{
			private String path;
			private File saveDir;
			private FileDownloadered loader;
			public DownloadTask(String path, File saveDir) {
				this.path = path;
				this.saveDir = saveDir;
			}
			/**
			 * ˳
			 */
			public void exit(){
				if(loader!=null) loader.exit();
			}
			
			public void run() {
				try {
					loader = new FileDownloadered(getApplicationContext(), path, saveDir, 3);
					progressbar.setMax(loader.getFileSize());//ý̶
					loader.download(new com.jay.example.service.DownloadProgressListener() {
						public void onDownloadSize(int size) {
							Message msg = new Message();
							msg.what = 1;
							msg.getData().putInt("size", size);
							handler.sendMessage(msg);
						}
					});
				} catch (Exception e) {
					e.printStackTrace();
					handler.sendMessage(handler.obtainMessage(-1));
				}
			}			
		}
    }
}
