package com.jay.example.db;

import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

/*
 * һҵbean,ݿز
 * */

public class FileService {
	//ݿ
	private DBOpenHelper openHelper;
	
	//ڹ췽иĶʵݿ
	public FileService(Context context) {
		openHelper = new DBOpenHelper(context);
	}
	
	/**
	 * ָURIÿ߳Ѿصļ
	 * @param path
	 * @return 
	 * */
	public Map<Integer, Integer> getData(String path)
	{
		//ÿɶݿ,ͨڲʵַصʵǿдݿ
		SQLiteDatabase db = openHelper.getReadableDatabase();
		//ص·ѯֳ,صCursorָһ¼֮ǰ
		Cursor cursor = db.rawQuery("select threadid, downlength from filedownlog where downpath=?",
				new String[]{path});
		//һϣڴÿ߳صļ
		Map<Integer,Integer> data = new HashMap<Integer, Integer>();
		//ӵһ¼ʼCursor
		while(cursor.moveToNext())
		{
			//߳id߳صĳȴŵdataϣ
			data.put(cursor.getInt(0), cursor.getInt(1));
			data.put(cursor.getInt(cursor.getColumnIndexOrThrow("threadid")),
					cursor.getInt(cursor.getColumnIndexOrThrow("downlength")));
		}
		cursor.close();//رcursor,ͷԴ;
		db.close();
		return data;
	}
	
	/**
	 * ÿ߳Ѿصļ
	 * @param path ص·
	 * @param map ڵdiѾصĳȵļ
	*/
	public void save(String path,Map<Integer,Integer> map)
	{
		SQLiteDatabase db = openHelper.getWritableDatabase();
		//,Ϊ˴Ҫ
		db.beginTransaction();
		try{
			//ʹǿforѭݼ
			for(Map.Entry<Integer, Integer> entry : map.entrySet())
			{
				//ض·ض߳IDѾص
				db.execSQL("insert into filedownlog(downpath, threadid, downlength) values(?,?,?)",
						new Object[]{path, entry.getKey(), entry.getValue()});
			}
			//һɹı־,ɹύ,ûø÷Ļôع
			//ݿ
			db.setTransactionSuccessful();
		}finally{
			//һ
			db.endTransaction();
		}
		db.close();
	}
	
	/**
	 * ʵʱÿ߳Ѿصļ
	 * @param path
	 * @param map
	 */
	public void update(String path,int threadId,int pos)
	{
		SQLiteDatabase db = openHelper.getWritableDatabase();
		//ض·ض߳صļ
		db.execSQL("update filedownlog set downlength=? where downpath=? and threadid=?",
				new Object[]{pos, path, threadId});
		db.close();
	}
	
	
	/**
	 *ļɺɾӦؼ¼
	 *@param path 
	 */
	public void delete(String path)
	{
		SQLiteDatabase db = openHelper.getWritableDatabase();
		db.execSQL("delete from filedownlog where downpath=?", new Object[]{path});
		db.close();
	}
	
}
